//=============================================================================
// MountainDew.
//=============================================================================
class MountainDewDistortion extends MountainDewCan;

#exec TEXTURE IMPORT NAME="MountainDewDistortion" FILE="C:\DeusEx\MarkistanCity\Textures\MountainDewDistortion.bmp" GROUP=Skins

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

defaultproperties
{
     rechargeAmount=90
     healAmount=70
     mpRechargeAmount=90
     maxCopies=6
     bCanHaveMultipleCopies=True
     InventoryGroup=157
     bActivatable=True
     ItemName="|p3Mountain Dew Distortion"
     ItemArticle="some"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Sodacan'
     PickupViewMesh=LodMesh'DeusExItems.Sodacan'
     ThirdPersonMesh=LodMesh'DeusExItems.Sodacan'
     LandSound=Sound'DeusExSounds.Generic.MetalHit1'
     Icon=Texture'Markistan.Icons.BeltIconMD1'
     Description="This is a can of awesome. Distortion Edition, lime flavored."
     beltDescription="|p3DSTRTN"
     Skin=Texture'MountainDewDistortion'
     Mesh=LodMesh'DeusExItems.SodaCan'
     CollisionRadius=3.000000
     CollisionHeight=4.500000
     Mass=5.000000
     Buoyancy=3.000000
}
